/**
 ***********************************************************************************************************************
 * Copyright (c) 2020, China Mobile Communications Group Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * @file        cputime_test.c
 *
 * @brief       The test file for cputime.
 *
 * @revision
 * Date         Author          Notes
 * 2020-02-20   OneOS Team      First Version
 ***********************************************************************************************************************
 */

#include <board.h>
#include <os_clock.h>
#include <oneos_config.h>
#include <timer/clocksource.h>
#include <shell.h>

void clocksource_test(int argc, char *argv[])
{
    os_uint32_t i;
    os_uint64_t start, now, delay;
    os_tick_t tick_start, tick_now;

    os_task_t *self = os_task_self();
    os_uint8_t task_prio = self->current_priority;
    os_uint8_t high_prio = 1;
    os_task_control(self, OS_TASK_CTRL_CHANGE_PRIORITY, &high_prio);

    for (i = 0; i < 14; i++)
    {
        delay = 1ULL << i;
        
        /* sync tick */
        os_task_msleep(1);

        tick_start = os_tick_get();
        start = os_clocksource_gettime();
        os_task_msleep(delay);
        tick_now = os_tick_get();
        now = os_clocksource_gettime();

        os_kprintf("msleep start tick: %d\r\n", tick_start);
        os_kprintf("msleep now   tick: %d             delta tick: %d\r\n",
                   tick_now, tick_now - tick_start);
        os_kprintf("msleep start time: %d.%09d\r\n", (int)(start / NSEC_PER_SEC), (int)(start % NSEC_PER_SEC));
        os_kprintf("msleep now   time: %d.%09d    %Ld, delta time: %d us\r\n\r\n",
                   (int)(now / NSEC_PER_SEC), (int)(now % NSEC_PER_SEC), delay, (int)((now - start) / 1000));
    }

    for (i = 0; i < 14; i++)
    {
        delay = (1ULL << i) * 1000 * 1000;
        tick_start = os_tick_get();
        start = os_clocksource_gettime();
        os_clocksource_ndelay(delay);
        tick_now = os_tick_get();
        now = os_clocksource_gettime();

        os_kprintf("udelay start tick: %d\r\n", tick_start);
        os_kprintf("udelay now   tick: %d             delta tick: %d\r\n",
                   tick_now, tick_now - tick_start);
        os_kprintf("udelay start time: %d.%09d\r\n", (int)(start / NSEC_PER_SEC), (int)(start % NSEC_PER_SEC));
        os_kprintf("udelay now   time: %d.%09d    %Ld, delta time: %d us\r\n\r\n",
                   (int)(now / NSEC_PER_SEC), (int)(now % NSEC_PER_SEC), delay, (int)((now - start) / 1000));
    }

    os_task_control(self, OS_TASK_CTRL_CHANGE_PRIORITY, &task_prio);
}

SH_CMD_EXPORT(clocksource_test, clocksource_test, "clocksource_test");

