/**
 * \file
 *
 * \brief Generic Clock Controller v210 related functionality.
 *
 * Copyright (c) 2014-2018 Microchip Technology Inc. and its subsidiaries.
 *
 * \asf_license_start
 *
 * \page License
 *
 * Subject to your compliance with these terms, you may use Microchip
 * software and any derivatives exclusively with Microchip products.
 * It is your responsibility to comply with third party license terms applicable
 * to your use of third party software (including open source software) that
 * may accompany Microchip software.
 *
 * THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE,
 * INCLUDING ANY IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY,
 * AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL MICROCHIP BE
 * LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL OR CONSEQUENTIAL
 * LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND WHATSOEVER RELATED TO THE
 * SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS BEEN ADVISED OF THE
 * POSSIBILITY OR THE DAMAGES ARE FORESEEABLE.  TO THE FULLEST EXTENT
 * ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN ANY WAY
 * RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY,
 * THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *
 * \asf_license_stop
 *
 */

#include <hpl_gclk_config.h>
#include <hpl_init.h>
#include <utils_assert.h>

/* Make the macro name compatible to different header versions */
#if !defined(GCLK_GENCTRL_SRC_FDPLL) && defined(GCLK_GENCTRL_SRC_DPLL96M)
#define GCLK_GENCTRL_SRC_FDPLL GCLK_GENCTRL_SRC_DPLL96M
#endif

/**
 * \brief Initializes generators
 */
void _gclk_init_generators(void)
{

#if CONF_GCLK_GENERATOR_0_CONFIG == 1
	hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_0_DIV) | GCLK_GENDIV_ID(0));
	hri_gclk_write_GENCTRL_reg(
	    GCLK,
	    (CONF_GCLK_GEN_0_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos) | (CONF_GCLK_GEN_0_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos)
	        | (CONF_GCLK_GEN_0_OE << GCLK_GENCTRL_OE_Pos) | (CONF_GCLK_GEN_0_OOV << GCLK_GENCTRL_OOV_Pos)
	        | (CONF_GCLK_GEN_0_IDC << GCLK_GENCTRL_IDC_Pos) | (CONF_GCLK_GENERATOR_0_CONFIG << GCLK_GENCTRL_GENEN_Pos)
	        | CONF_GCLK_GEN_0_SRC | GCLK_GENCTRL_ID(0));
#endif

#if CONF_GCLK_GENERATOR_1_CONFIG == 1
	hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_1_DIV) | GCLK_GENDIV_ID(1));
	hri_gclk_write_GENCTRL_reg(
	    GCLK,
	    (CONF_GCLK_GEN_1_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos) | (CONF_GCLK_GEN_1_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos)
	        | (CONF_GCLK_GEN_1_OE << GCLK_GENCTRL_OE_Pos) | (CONF_GCLK_GEN_1_OOV << GCLK_GENCTRL_OOV_Pos)
	        | (CONF_GCLK_GEN_1_IDC << GCLK_GENCTRL_IDC_Pos) | (CONF_GCLK_GENERATOR_1_CONFIG << GCLK_GENCTRL_GENEN_Pos)
	        | CONF_GCLK_GEN_1_SRC | GCLK_GENCTRL_ID(1));
#endif

#if CONF_GCLK_GENERATOR_2_CONFIG == 1
	hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_2_DIV) | GCLK_GENDIV_ID(2));
	hri_gclk_write_GENCTRL_reg(
	    GCLK,
	    (CONF_GCLK_GEN_2_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos) | (CONF_GCLK_GEN_2_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos)
	        | (CONF_GCLK_GEN_2_OE << GCLK_GENCTRL_OE_Pos) | (CONF_GCLK_GEN_2_OOV << GCLK_GENCTRL_OOV_Pos)
	        | (CONF_GCLK_GEN_2_IDC << GCLK_GENCTRL_IDC_Pos) | (CONF_GCLK_GENERATOR_2_CONFIG << GCLK_GENCTRL_GENEN_Pos)
	        | CONF_GCLK_GEN_2_SRC | GCLK_GENCTRL_ID(2));
#endif

#if CONF_GCLK_GENERATOR_3_CONFIG == 1
	hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_3_DIV) | GCLK_GENDIV_ID(3));
	hri_gclk_write_GENCTRL_reg(
	    GCLK,
	    (CONF_GCLK_GEN_3_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos) | (CONF_GCLK_GEN_3_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos)
	        | (CONF_GCLK_GEN_3_OE << GCLK_GENCTRL_OE_Pos) | (CONF_GCLK_GEN_3_OOV << GCLK_GENCTRL_OOV_Pos)
	        | (CONF_GCLK_GEN_3_IDC << GCLK_GENCTRL_IDC_Pos) | (CONF_GCLK_GENERATOR_3_CONFIG << GCLK_GENCTRL_GENEN_Pos)
	        | CONF_GCLK_GEN_3_SRC | GCLK_GENCTRL_ID(3));
#endif

#if CONF_GCLK_GENERATOR_4_CONFIG == 1
	hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_4_DIV) | GCLK_GENDIV_ID(4));
	hri_gclk_write_GENCTRL_reg(
	    GCLK,
	    (CONF_GCLK_GEN_4_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos) | (CONF_GCLK_GEN_4_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos)
	        | (CONF_GCLK_GEN_4_OE << GCLK_GENCTRL_OE_Pos) | (CONF_GCLK_GEN_4_OOV << GCLK_GENCTRL_OOV_Pos)
	        | (CONF_GCLK_GEN_4_IDC << GCLK_GENCTRL_IDC_Pos) | (CONF_GCLK_GENERATOR_4_CONFIG << GCLK_GENCTRL_GENEN_Pos)
	        | CONF_GCLK_GEN_4_SRC | GCLK_GENCTRL_ID(4));
#endif

#if CONF_GCLK_GENERATOR_5_CONFIG == 1
	hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_5_DIV) | GCLK_GENDIV_ID(5));
	hri_gclk_write_GENCTRL_reg(
	    GCLK,
	    (CONF_GCLK_GEN_5_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos) | (CONF_GCLK_GEN_5_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos)
	        | (CONF_GCLK_GEN_5_OE << GCLK_GENCTRL_OE_Pos) | (CONF_GCLK_GEN_5_OOV << GCLK_GENCTRL_OOV_Pos)
	        | (CONF_GCLK_GEN_5_IDC << GCLK_GENCTRL_IDC_Pos) | (CONF_GCLK_GENERATOR_5_CONFIG << GCLK_GENCTRL_GENEN_Pos)
	        | CONF_GCLK_GEN_5_SRC | GCLK_GENCTRL_ID(5));
#endif

#if CONF_GCLK_GENERATOR_6_CONFIG == 1
	hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_6_DIV) | GCLK_GENDIV_ID(6));
	hri_gclk_write_GENCTRL_reg(
	    GCLK,
	    (CONF_GCLK_GEN_6_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos) | (CONF_GCLK_GEN_6_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos)
	        | (CONF_GCLK_GEN_6_OE << GCLK_GENCTRL_OE_Pos) | (CONF_GCLK_GEN_6_OOV << GCLK_GENCTRL_OOV_Pos)
	        | (CONF_GCLK_GEN_6_IDC << GCLK_GENCTRL_IDC_Pos) | (CONF_GCLK_GENERATOR_6_CONFIG << GCLK_GENCTRL_GENEN_Pos)
	        | CONF_GCLK_GEN_6_SRC | GCLK_GENCTRL_ID(6));
#endif

#if CONF_GCLK_GENERATOR_7_CONFIG == 1
	hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_7_DIV) | GCLK_GENDIV_ID(7));
	hri_gclk_write_GENCTRL_reg(
	    GCLK,
	    (CONF_GCLK_GEN_7_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos) | (CONF_GCLK_GEN_7_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos)
	        | (CONF_GCLK_GEN_7_OE << GCLK_GENCTRL_OE_Pos) | (CONF_GCLK_GEN_7_OOV << GCLK_GENCTRL_OOV_Pos)
	        | (CONF_GCLK_GEN_7_IDC << GCLK_GENCTRL_IDC_Pos) | (CONF_GCLK_GENERATOR_7_CONFIG << GCLK_GENCTRL_GENEN_Pos)
	        | CONF_GCLK_GEN_7_SRC | GCLK_GENCTRL_ID(7));
#endif

#if CONF_GCLK_GENERATOR_8_CONFIG == 1
	hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_8_DIV) | GCLK_GENDIV_ID(8));
	hri_gclk_write_GENCTRL_reg(
	    GCLK,
	    (CONF_GCLK_GEN_8_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos) | (CONF_GCLK_GEN_8_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos)
	        | (CONF_GCLK_GEN_8_OE << GCLK_GENCTRL_OE_Pos) | (CONF_GCLK_GEN_8_OOV << GCLK_GENCTRL_OOV_Pos)
	        | (CONF_GCLK_GEN_8_IDC << GCLK_GENCTRL_IDC_Pos) | (CONF_GCLK_GENERATOR_8_CONFIG << GCLK_GENCTRL_GENEN_Pos)
	        | CONF_GCLK_GEN_8_SRC | GCLK_GENCTRL_ID(8));
#endif
}

void _gclk_init_generators_by_fref(uint32_t bm)
{

#if CONF_GCLK_GENERATOR_0_CONFIG == 1
	if (bm & (1ul << 0)) {
		hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_0_DIV) | GCLK_GENDIV_ID(0));
		hri_gclk_write_GENCTRL_reg(
		    GCLK,
		    (CONF_GCLK_GEN_0_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos)
		        | (CONF_GCLK_GEN_0_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos) | (CONF_GCLK_GEN_0_OE << GCLK_GENCTRL_OE_Pos)
		        | (CONF_GCLK_GEN_0_OOV << GCLK_GENCTRL_OOV_Pos) | (CONF_GCLK_GEN_0_IDC << GCLK_GENCTRL_IDC_Pos)
		        | (CONF_GCLK_GENERATOR_0_CONFIG << GCLK_GENCTRL_GENEN_Pos) | CONF_GCLK_GEN_0_SRC | GCLK_GENCTRL_ID(0));
	}
#endif

#if CONF_GCLK_GENERATOR_1_CONFIG == 1
	if (bm & (1ul << 1)) {
		hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_1_DIV) | GCLK_GENDIV_ID(1));
		hri_gclk_write_GENCTRL_reg(
		    GCLK,
		    (CONF_GCLK_GEN_1_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos)
		        | (CONF_GCLK_GEN_1_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos) | (CONF_GCLK_GEN_1_OE << GCLK_GENCTRL_OE_Pos)
		        | (CONF_GCLK_GEN_1_OOV << GCLK_GENCTRL_OOV_Pos) | (CONF_GCLK_GEN_1_IDC << GCLK_GENCTRL_IDC_Pos)
		        | (CONF_GCLK_GENERATOR_1_CONFIG << GCLK_GENCTRL_GENEN_Pos) | CONF_GCLK_GEN_1_SRC | GCLK_GENCTRL_ID(1));
	}
#endif

#if CONF_GCLK_GENERATOR_2_CONFIG == 1
	if (bm & (1ul << 2)) {
		hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_2_DIV) | GCLK_GENDIV_ID(2));
		hri_gclk_write_GENCTRL_reg(
		    GCLK,
		    (CONF_GCLK_GEN_2_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos)
		        | (CONF_GCLK_GEN_2_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos) | (CONF_GCLK_GEN_2_OE << GCLK_GENCTRL_OE_Pos)
		        | (CONF_GCLK_GEN_2_OOV << GCLK_GENCTRL_OOV_Pos) | (CONF_GCLK_GEN_2_IDC << GCLK_GENCTRL_IDC_Pos)
		        | (CONF_GCLK_GENERATOR_2_CONFIG << GCLK_GENCTRL_GENEN_Pos) | CONF_GCLK_GEN_2_SRC | GCLK_GENCTRL_ID(2));
	}
#endif

#if CONF_GCLK_GENERATOR_3_CONFIG == 1
	if (bm & (1ul << 3)) {
		hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_3_DIV) | GCLK_GENDIV_ID(3));
		hri_gclk_write_GENCTRL_reg(
		    GCLK,
		    (CONF_GCLK_GEN_3_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos)
		        | (CONF_GCLK_GEN_3_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos) | (CONF_GCLK_GEN_3_OE << GCLK_GENCTRL_OE_Pos)
		        | (CONF_GCLK_GEN_3_OOV << GCLK_GENCTRL_OOV_Pos) | (CONF_GCLK_GEN_3_IDC << GCLK_GENCTRL_IDC_Pos)
		        | (CONF_GCLK_GENERATOR_3_CONFIG << GCLK_GENCTRL_GENEN_Pos) | CONF_GCLK_GEN_3_SRC | GCLK_GENCTRL_ID(3));
	}
#endif

#if CONF_GCLK_GENERATOR_4_CONFIG == 1
	if (bm & (1ul << 4)) {
		hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_4_DIV) | GCLK_GENDIV_ID(4));
		hri_gclk_write_GENCTRL_reg(
		    GCLK,
		    (CONF_GCLK_GEN_4_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos)
		        | (CONF_GCLK_GEN_4_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos) | (CONF_GCLK_GEN_4_OE << GCLK_GENCTRL_OE_Pos)
		        | (CONF_GCLK_GEN_4_OOV << GCLK_GENCTRL_OOV_Pos) | (CONF_GCLK_GEN_4_IDC << GCLK_GENCTRL_IDC_Pos)
		        | (CONF_GCLK_GENERATOR_4_CONFIG << GCLK_GENCTRL_GENEN_Pos) | CONF_GCLK_GEN_4_SRC | GCLK_GENCTRL_ID(4));
	}
#endif

#if CONF_GCLK_GENERATOR_5_CONFIG == 1
	if (bm & (1ul << 5)) {
		hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_5_DIV) | GCLK_GENDIV_ID(5));
		hri_gclk_write_GENCTRL_reg(
		    GCLK,
		    (CONF_GCLK_GEN_5_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos)
		        | (CONF_GCLK_GEN_5_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos) | (CONF_GCLK_GEN_5_OE << GCLK_GENCTRL_OE_Pos)
		        | (CONF_GCLK_GEN_5_OOV << GCLK_GENCTRL_OOV_Pos) | (CONF_GCLK_GEN_5_IDC << GCLK_GENCTRL_IDC_Pos)
		        | (CONF_GCLK_GENERATOR_5_CONFIG << GCLK_GENCTRL_GENEN_Pos) | CONF_GCLK_GEN_5_SRC | GCLK_GENCTRL_ID(5));
	}
#endif

#if CONF_GCLK_GENERATOR_6_CONFIG == 1
	if (bm & (1ul << 6)) {
		hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_6_DIV) | GCLK_GENDIV_ID(6));
		hri_gclk_write_GENCTRL_reg(
		    GCLK,
		    (CONF_GCLK_GEN_6_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos)
		        | (CONF_GCLK_GEN_6_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos) | (CONF_GCLK_GEN_6_OE << GCLK_GENCTRL_OE_Pos)
		        | (CONF_GCLK_GEN_6_OOV << GCLK_GENCTRL_OOV_Pos) | (CONF_GCLK_GEN_6_IDC << GCLK_GENCTRL_IDC_Pos)
		        | (CONF_GCLK_GENERATOR_6_CONFIG << GCLK_GENCTRL_GENEN_Pos) | CONF_GCLK_GEN_6_SRC | GCLK_GENCTRL_ID(6));
	}
#endif

#if CONF_GCLK_GENERATOR_7_CONFIG == 1
	if (bm & (1ul << 7)) {
		hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_7_DIV) | GCLK_GENDIV_ID(7));
		hri_gclk_write_GENCTRL_reg(
		    GCLK,
		    (CONF_GCLK_GEN_7_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos)
		        | (CONF_GCLK_GEN_7_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos) | (CONF_GCLK_GEN_7_OE << GCLK_GENCTRL_OE_Pos)
		        | (CONF_GCLK_GEN_7_OOV << GCLK_GENCTRL_OOV_Pos) | (CONF_GCLK_GEN_7_IDC << GCLK_GENCTRL_IDC_Pos)
		        | (CONF_GCLK_GENERATOR_7_CONFIG << GCLK_GENCTRL_GENEN_Pos) | CONF_GCLK_GEN_7_SRC | GCLK_GENCTRL_ID(7));
	}
#endif

#if CONF_GCLK_GENERATOR_8_CONFIG == 1
	if (bm & (1ul << 8)) {
		hri_gclk_write_GENDIV_reg(GCLK, GCLK_GENDIV_DIV(CONF_GCLK_GEN_8_DIV) | GCLK_GENDIV_ID(8));
		hri_gclk_write_GENCTRL_reg(
		    GCLK,
		    (CONF_GCLK_GEN_8_RUNSTDBY << GCLK_GENCTRL_RUNSTDBY_Pos)
		        | (CONF_GCLK_GEN_8_DIVSEL << GCLK_GENCTRL_DIVSEL_Pos) | (CONF_GCLK_GEN_8_OE << GCLK_GENCTRL_OE_Pos)
		        | (CONF_GCLK_GEN_8_OOV << GCLK_GENCTRL_OOV_Pos) | (CONF_GCLK_GEN_8_IDC << GCLK_GENCTRL_IDC_Pos)
		        | (CONF_GCLK_GENERATOR_8_CONFIG << GCLK_GENCTRL_GENEN_Pos) | CONF_GCLK_GEN_8_SRC | GCLK_GENCTRL_ID(8));
	}
#endif
}
