/**

*******************************************************************************
****************************************
 * Copyright (c) 2020, China Mobile Communications Group Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * @file        drv_common.c
 *
 * @brief       This file provides systick time init/IRQ and board init
functions.
 *
 * @revision
 * Date         Author          Notes
 * 2020-02-20   OneOS Team      First Version

*******************************************************************************
****************************************
 */

#include "board.h"
#include <oneos_config.h>
#include <os_types.h>
#include <os_stddef.h>
#include <os_irq.h>
#include <os_clock.h>
#include <os_hw.h>
#include <os_memory.h>
#include "board.h"

#include "drv_gpio.h"
//#include "drv_uart.h"
#include "drv_common.h"
#include <samd21.h>
#include <hal_init.h>
#include <os_version.h>

void os_hw_systick_init(void)
{
    /* systick for kernel tick */
    SysTick->LOAD  = SystemCoreClock / OS_TICK_PER_SECOND;      /* set reload register */
    SysTick->VAL   = 0UL;                                       /* Load the systick Counter Value */
    SysTick->CTRL |= 3;
}


void SysTick_Handler(void)
{
    /* enter interrupt */
    os_interrupt_enter();

    //HAL_IncTick();
    os_tick_increase();

    /* leave interrupt */
    os_interrupt_leave();
}


void os_hw_board_init()
{
    /* System clock initialization */
    init_mcu();

    os_hw_systick_init();

    /* Pin driver initialization is open by default */
#ifdef OS_USING_PIN
    os_hw_pin_init();
#endif

    /* Heap initialization */
#if defined(OS_USING_HEAP)
    os_system_heap_init((void *)HEAP_BEGIN, (void *)HEAP_END);
#endif


    os_board_auto_init();

    /* Set the shell console output device */
#ifdef OS_USING_CONSOLE
    os_console_set_device(OS_CONSOLE_DEVICE_NAME);
#endif

    os_kprintf("\r\nOneOS start, version: %s %s %s\r\n", ONEOS_VERSION, __DATE__, __TIME__);

}

