/**
 ***********************************************************************************************************************
 * Copyright (c) 2020, China Mobile Communications Group Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on 
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the 
 * specific language governing permissions and limitations under the License.
 *
 * @file        Provide all external header files of kernel(except os_dbg.h and os_dbg_ext.h).
 *
 * @revision
 * Date         Author          Notes
 * 2020-03-05   OneOS Team      First version.
 ***********************************************************************************************************************
 */

#ifndef __OS_KERNEL_H__
#define __OS_KERNEL_H__

#include <os_types.h>
#include <os_stddef.h>
#include <os_errno.h>
#include <os_list.h>
#include <os_util.h>
#include <os_assert.h>
#include <os_hw.h>
#include <os_irq.h>
#include <os_clock.h>
#include <os_timer.h>
#include <os_object.h>
#include <os_task.h>
#include <os_sem.h>
#include <os_mutex.h>
#include <os_event.h>
#include <os_mq.h>
#include <os_mailbox.h>
#include <os_memory.h>
#include <os_device.h>
#include <os_module.h>
#include <extend/os_workqueue.h>
#include <extend/os_completion.h>
#include <extend/os_dataqueue.h>

#endif /* __OS_KERNEL_H__ */

