/**
 ***********************************************************************************************************************
 * Copyright (c) 2020, China Mobile Communications Group Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on 
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the 
 * specific language governing permissions and limitations under the License.
 *
 * @file        os_version.h
 *
 * @brief       Configure OneOS version.
 *
 * @revision
 * Date         Author          Notes
 * 2020-05-29   OneOS Team      First version
 ***********************************************************************************************************************
 */

#ifndef __OS_VERSION__
#define __OS_VERSION__

/**
 ***********************************************************************************************************************
 * @def         ONEOS_VERSION
 *
 * @brief       Version number format is OneOS-Vx.y.z
 *                  - x:     Major version number.
 *                  - y:     Minor version number.
 *                  - z:     Revision number.
 ***********************************************************************************************************************
 */
#define ONEOS_VERSION   "OneOS-V1.2.0-T4"

#endif /* __OS_VERSION__ */

