#include <board.h>
#include <drv_cfg.h>
#include <os_hw.h>

#include <os_memory.h>
#include <drv_log.h>
#include <string.h>
#include <stdlib.h>

#include <os_mailbox.h>

#ifdef OS_USING_SHELL
#include <shell.h>
#endif

os_mailbox_t *mb_iic = NULL;
#define MB_MAX_MAILS    10

typedef struct
{
    os_uint32_t temp;
    os_uint32_t humi;
}temp_humi_s;

void entry_mb_tid1(void * parameter)
{
    temp_humi_s *temp_humi = NULL;
    temp_humi = (temp_humi_s *)os_malloc(sizeof(temp_humi_s));
    ASSERT(temp_humi != NULL);

    while(1)
    {
        os_task_msleep(1000);
        temp_humi->temp = rand() % 50;
        temp_humi->humi = rand() % 100;
        os_kprintf("start send:temp[%d], humi[%d]\r\n", temp_humi->temp, temp_humi->humi);
        os_mb_send(mb_iic, (os_uint32_t)temp_humi, OS_IPC_WAITING_FOREVER);
    }
}


void entry_mb_tid2(void * parameter)
{
    os_uint32_t data = 0;
    while (1)
    {
        os_mb_recv(mb_iic, &data, OS_IPC_WAITING_FOREVER);
        os_kprintf("recv data:temp[%d], humi[%d]\r\n", ((temp_humi_s *)data)->temp, ((temp_humi_s *)data)->humi);
    }
}


static void oneos_mb_test(void)
{
    os_task_t *tid1, *tid2;

    mb_iic = os_mb_create("mb", MB_MAX_MAILS, OS_IPC_FLAG_FIFO);
    if (mb_iic == NULL)
    {
        os_kprintf("os_mb_create err\r\n");
        return;
    }

    tid1 = os_task_create("mb_tid1", entry_mb_tid1, NULL, 512, 5, 10);
    OS_ASSERT(tid1 != NULL);
    os_task_startup(tid1);

    tid2 = os_task_create("mb_tid2", entry_mb_tid2, NULL, 512, 5, 10);
    OS_ASSERT(tid2 != NULL);
    os_task_startup(tid2);

    
}

#ifdef OS_USING_SHELL
SH_CMD_EXPORT(oneos_mb_test, oneos_mb_test,"oneos_mb_test");
#endif

