#include <oneos_config.h>
#include <os_dbg.h>
#include <os_errno.h>
#include <os_task.h>
#include <shell.h>
#include <os_event.h>

#define TEST_TAG        "TEST"
#define TASK_STACK_SIZE 1024
#define TASK_PRIORITY   15
#define TASK_TIMESLICE  10

#define EVENT_FLAG_0 (1 << 0)
#define EVENT_FLAG_1 (1 << 1)
#define EVENT_FLAG_2 (1 << 2)

static os_event_t *event_dynamic = OS_NULL;

void task_entry(void *para)
{
    os_uint32_t recv_event;

    while (1)
    {        
        if (os_event_recv(event_dynamic, (EVENT_FLAG_0 | EVENT_FLAG_1 | EVENT_FLAG_2),
                          OS_EVENT_OPTION_AND | OS_EVENT_OPTION_CLEAR,
                          OS_IPC_WAITING_FOREVER, &recv_event) == OS_EOK)
        {
            LOG_W(TEST_TAG, "task: AND recv event:0x%x", recv_event);
        }
    }
}

void event_dynamic_sample(void)
{
    os_task_t *task = OS_NULL;

    event_dynamic = os_event_create("event_dynamic", OS_IPC_FLAG_FIFO);
    if (!event_dynamic)
    {
        LOG_E(TEST_TAG, "event_dynamic_sample: event create err");
        return;
    }

    task = os_task_create("task_event", 
                           task_entry, 
                           OS_NULL, 
                           TASK_STACK_SIZE, 
                           TASK_PRIORITY, 
                           TASK_TIMESLICE);
    if (task)
    {
        os_task_startup(task);
    }

    LOG_W(TEST_TAG, "event_dynamic_sample: send event:0x%x", EVENT_FLAG_0);
    os_event_send(event_dynamic, EVENT_FLAG_0);
    os_task_sleep(400);

    LOG_W(TEST_TAG, "event_dynamic_sample: send event:0x%x", EVENT_FLAG_1);
    os_event_send(event_dynamic, EVENT_FLAG_1);
    os_task_sleep(400);

    LOG_W(TEST_TAG, "event_dynamic_sample: send event:0x%x", EVENT_FLAG_2);
    os_event_send(event_dynamic, EVENT_FLAG_2);
    os_task_sleep(400);

    LOG_W(TEST_TAG, "event_dynamic_sample: send event:0x%x", EVENT_FLAG_0);
    os_event_send(event_dynamic, EVENT_FLAG_0);
    os_task_sleep(400);

    LOG_W(TEST_TAG, "event_dynamic_sample: send event:0x%x", EVENT_FLAG_1);
    os_event_send(event_dynamic, EVENT_FLAG_1);
    os_task_sleep(400);

    LOG_W(TEST_TAG, "event_dynamic_sample: send event:0x%x", EVENT_FLAG_2);
    os_event_send(event_dynamic, EVENT_FLAG_2);
    os_task_sleep(400);
}

SH_CMD_EXPORT(dynamic_event, event_dynamic_sample, "test dynamic event");
