#include <oneos_config.h>
#include <os_dbg.h>
#include <os_errno.h>
#include <os_task.h>
#include <shell.h>
#include <os_sem.h>

#define TEST_TAG        "TEST"
#define TASK_STACK_SIZE 1024
#define TASK1_PRIORITY  15
#define TASK2_PRIORITY  16
#define TASK_TIMESLICE  10

static os_uint32_t count = 0;
static os_sem_t* sem_dynamic;

void task1_entry(void *para)
{
    while (1)
    {        
        LOG_W(TEST_TAG, "task1_entry semaphore wait");
        if (OS_EOK == os_sem_wait(sem_dynamic, OS_IPC_WAITING_FOREVER))
        {
            LOG_W(TEST_TAG, "task1_entry semaphore wait done, count:%d", count);
        }
        else
        {
            LOG_W(TEST_TAG, "task1_entry semaphore wait fail");
        }
    }
}

void task2_entry(void *para)
{
    while (1)
    {
        count++;
        LOG_W(TEST_TAG, "task2_entry semaphore post");
        if (OS_EOK != os_sem_post(sem_dynamic))
        {
            LOG_W(TEST_TAG, "task2_entry semaphore post fail");
        }

        LOG_W(TEST_TAG, "task2_entry sleep");
        os_task_sleep(500);
    }
}

void semaphore_dynamic_sample(void)
{
    os_task_t *task1 = OS_NULL;
    os_task_t *task2 = OS_NULL;

    sem_dynamic = os_sem_create("sem_dynamic", 0, OS_IPC_FLAG_FIFO);

    task1 = os_task_create("task1", 
                           task1_entry, 
                           OS_NULL, 
                           TASK_STACK_SIZE, 
                           TASK1_PRIORITY, 
                           TASK_TIMESLICE);
    if (task1)
    {
        os_task_startup(task1);
    }

    task2 = os_task_create("task2", 
                           task2_entry, 
                           OS_NULL, 
                           TASK_STACK_SIZE, 
                           TASK2_PRIORITY, 
                           TASK_TIMESLICE);
    if (task2)
    {
        os_task_startup(task2);
    }
}

SH_CMD_EXPORT(dynamic_sem, semaphore_dynamic_sample, "test dynamic semaphore");
