#include "oneos_config.h"
#include <bsp.h>
#include <sam.h>
#include <drv_gpio.h>
#include <hpl_sercom_config.h>

#ifdef BSP_USING_UART

#ifdef BSP_USING_UART0
UART_HandleTypeDef huart0 = 
{
    .Init = 
    {
        .bus = PM_BUS_APBC,
        .sercom = SERCOM0, 
        .irqnum = SERCOM0_IRQn,
        .sampr = CONF_SERCOM_0_USART_SAMPR,
        .clock_rate = CONF_GCLK_SERCOM0_CORE_FREQUENCY,
        .sercom_core_id = SERCOM0_GCLK_ID_CORE,
        .sercom_core_src = CONF_GCLK_SERCOM0_CORE_SRC,
        .com_tx =
        {
            .pin_num = PA04,
            .pin_func = PINMUX_PA04D_SERCOM0_PAD0,    
        },
        .com_rx =
        {
            .pin_num = PA05,
            .pin_func = PINMUX_PA05D_SERCOM0_PAD1,    
        },
    }
};
#endif  /* BSP_USING_UART0 */

#ifdef BSP_USING_UART1
UART_HandleTypeDef huart1 = 
{
    .Init = 
    {
        .bus = PM_BUS_APBC,
        .sercom = SERCOM1, 
        .irqnum = SERCOM1_IRQn,
        .sampr = CONF_SERCOM_1_USART_SAMPR,
        .clock_rate = CONF_GCLK_SERCOM1_CORE_FREQUENCY,
        .sercom_core_id = SERCOM1_GCLK_ID_CORE,
        .sercom_core_src = CONF_GCLK_SERCOM1_CORE_SRC,
        .com_tx =
        {
            .pin_num = PA18,
            .pin_func = PINMUX_PA18C_SERCOM1_PAD2,    
        },
        .com_rx =
        {
            .pin_num = PA19,
            .pin_func = PINMUX_PA19C_SERCOM1_PAD3,    
        },
    }
};
#endif  /* BSP_USING_UART1 */

#ifdef BSP_USING_UART2
UART_HandleTypeDef huart2 = 
{
    .Init = 
    {
        .bus = PM_BUS_APBC,
        .sercom = SERCOM2, 
        .irqnum = SERCOM2_IRQn,
        .sampr = CONF_SERCOM_2_USART_SAMPR,
        .clock_rate = CONF_GCLK_SERCOM2_CORE_FREQUENCY,
        .sercom_core_id = SERCOM2_GCLK_ID_CORE,
        .sercom_core_src = CONF_GCLK_SERCOM2_CORE_SRC,
        .com_tx =
        {
            .pin_num = PA08,
            .pin_func = PINMUX_PA08D_SERCOM2_PAD0,    
        },
        .com_rx =
        {
            .pin_num = PA09,
            .pin_func = PINMUX_PA09D_SERCOM2_PAD1,    
        },
    }
};
#endif  /* BSP_USING_UART2 */

#ifdef BSP_USING_UART3
UART_HandleTypeDef huart3 = 
{
    .Init = 
    {
        .bus = PM_BUS_APBC,
        .sercom = SERCOM3, 
        .irqnum = SERCOM3_IRQn,
        .sampr = CONF_SERCOM_3_USART_SAMPR,
        .clock_rate = CONF_GCLK_SERCOM3_CORE_FREQUENCY,
        .sercom_core_id = SERCOM3_GCLK_ID_CORE,
        .sercom_core_src = CONF_GCLK_SERCOM3_CORE_SRC,
        .com_tx =
        {
            .pin_num = PA24,
            .pin_func = PINMUX_PA24C_SERCOM3_PAD2,    
        },
        .com_rx =
        {
            .pin_num = PA25,
            .pin_func = PINMUX_PA25C_SERCOM3_PAD3,    
        },
    }
};
#endif  /* BSP_USING_UART3 */

#ifdef BSP_USING_UART4
UART_HandleTypeDef huart4 = 
{
    .Init = 
    {
        .bus = PM_BUS_APBC,
        .sercom = SERCOM4, 
        .irqnum = SERCOM4_IRQn,
        .sampr = CONF_SERCOM_4_USART_SAMPR,
        .clock_rate = CONF_GCLK_SERCOM4_CORE_FREQUENCY,
        .sercom_core_id = SERCOM4_GCLK_ID_CORE,
        .sercom_core_src = CONF_GCLK_SERCOM4_CORE_SRC,
        .com_tx =
        {
            .pin_num = PB08,
            .pin_func = PINMUX_PB08D_SERCOM4_PAD0,    
        },
        .com_rx =
        {
            .pin_num = PB09,
            .pin_func = PINMUX_PB09D_SERCOM4_PAD1,    
        },
    }
};
#endif  /* BSP_USING_UART4 */

#ifdef BSP_USING_UART5
UART_HandleTypeDef huart5 = 
{
    .Init = 
    {
        .bus = PM_BUS_APBC,
        .sercom = SERCOM5, 
        .irqnum = SERCOM5_IRQn,
        .sampr = CONF_SERCOM_5_USART_SAMPR,
        .clock_rate = CONF_GCLK_SERCOM5_CORE_FREQUENCY,
        .sercom_core_id = SERCOM5_GCLK_ID_CORE,
        .sercom_core_src = CONF_GCLK_SERCOM5_CORE_SRC,
        .com_tx =
        {
            .pin_num = PB22,
            .pin_func = PINMUX_PB22D_SERCOM5_PAD2,    
        },
        .com_rx =
        {
            .pin_num = PB23,
            .pin_func = PINMUX_PB23D_SERCOM5_PAD3,    
        },
    }
};
#endif  /* BSP_USING_UART5 */

#endif /* BSP_USING_UART */

