#ifndef __BSP_H__
#define __BSP_H__

#include <os_types.h>
#include <hal_usart_async.h>
#include <hpl_gclk_base.h>
#include <hpl_pm_base.h>
#include <peripheral_clk_config.h>


#ifdef BSP_USING_UART

typedef struct __UART_PinDef
{
    os_uint32_t pin_num;
    os_uint32_t pin_func;
}UART_PinDef;

typedef struct __UART_InitTypeDef
{
    enum _pm_bus bus;
    void *sercom;
    IRQn_Type irqnum;
    os_uint32_t sampr;
    os_uint32_t clock_rate;
    os_uint32_t sercom_core_id;
    os_uint32_t sercom_core_src;
    UART_PinDef com_tx;
    UART_PinDef com_rx;

    enum usart_stop_bits StopBits;
    enum usart_parity Parity;
    enum usart_character_size WordLength;
    os_uint32_t baud;
    
}UART_InitTypeDef;

typedef struct __UART_HandleTypeDef
{
    struct usart_async_descriptor usart_xx;
    struct io_descriptor *io;  
//  USART_TypeDef            *Instance;                /*!< UART registers base address        */

  UART_InitTypeDef         Init;                     /*!< UART communication parameters      */

  os_uint8_t                  *pTxBuffPtr;              /*!< Pointer to UART Tx transfer Buffer */

  os_uint16_t                 TxXferSize;               /*!< UART Tx Transfer size              */

  __IO os_uint16_t            TxXferCount;              /*!< UART Tx Transfer Counter           */

  os_uint8_t                  *pRxBuffPtr;              /*!< Pointer to UART Rx transfer Buffer */

 os_uint16_t                 RxXferSize;               /*!< UART Rx Transfer size              */

  __IO os_uint16_t            RxXferCount;              /*!< UART Rx Transfer Counter           */



//  DMA_HandleTypeDef        *hdmatx;                  /*!< UART Tx DMA Handle parameters      */

//  DMA_HandleTypeDef        *hdmarx;                  /*!< UART Rx DMA Handle parameters      */


//  __IO HAL_UART_StateTypeDef    gState;              /*!< UART state information related to global Handle management
//                                                          and also related to Tx operations.
//                                                          This parameter can be a value of @ref HAL_UART_StateTypeDef */
//  __IO HAL_UART_StateTypeDef    RxState;             /*!< UART state information related to Rx operations.
//                                                          This parameter can be a value of @ref HAL_UART_StateTypeDef */
} UART_HandleTypeDef;

#endif /* BSP_USING_UART */


#endif /* __BSP_H__ */

