/*
 * This file is part of the MicroPython project, http://micropython.org/
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013, 2014 Damien P. George
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef MICROPY_INCLUDED_MIDDLE_WDT_H
#define MICROPY_INCLUDED_MIDDLE_WDT_H



#if MICROPY_PY_MACHINE_WDT

#include "py/obj.h"
#include "model_device.h"

#define IOCTL_WTD_INIT         		(0)
#define IOCTL_WTD_START           	(1)
#define IOCTL_WTD_KEEPALIVE         (2)

typedef device_info_t mp_wdt_device_handler;

typedef int mp_wdt_result;

#define MP_WDT_RESULT_OK (0)
#define MP_WDT_NAME_MAX (8)




extern void middle_wdt_print(mp_wdt_device_handler * wdt_device, const mp_print_t *print);


#endif
#endif
