/*
  Store and retrieve structured data in Flash memory.

  This example code is in the public domain.

  Written 30 Apr 2015 by Cristian Maglie
*/

#include <FlashStorage.h>

// Create a structure that is big enough to contain a name
// and a surname. The "valid" variable is set to "true" once
// the structure is filled with actual data for the first time.
typedef struct {
  boolean valid;
  char name[100];
  char surname[100];
} Person;

// Reserve a portion of flash memory to store a "Person" and
// call it "my_flash_store".
FlashStorage(my_flash_store, Person);

// Note: the area of flash memory reserved lost every time
// the sketch is uploaded on the board.

void setup() {
  SerialUSB.begin(9600);
  while (!SerialUSB) { }

  // Create a "Person" variable and call it "owner"
  Person owner;

  // Read the content of "my_flash_store" into the "owner" variable
  owner = my_flash_store.read();

  // If this is the first run the "valid" value should be "false"...
  if (owner.valid == false) {

    // ...in this case we ask for user data.
    SerialUSB.setTimeout(30000);
    SerialUSB.println("Insert your name:");
    String name = SerialUSB.readStringUntil('\n');
    SerialUSB.println("Insert your surname:");
    String surname = SerialUSB.readStringUntil('\n');

    // Fill the "owner" structure with the data entered by the user...
    name.toCharArray(owner.name, 100);
    surname.toCharArray(owner.surname, 100);
    // set "valid" to true, so the next time we know that we
    // have valid data inside
    owner.valid = true;

    // ...and finally save everything into "my_flash_store"
    my_flash_store.write(owner);

    // Print a confirmation of the data inserted.
    SerialUSB.println();
    SerialUSB.print("Your name: ");
    SerialUSB.println(owner.name);
    SerialUSB.print("and your surname: ");
    SerialUSB.println(owner.surname);
    SerialUSB.println("have been saved. Thank you!");

  } else {

    // Say hello to the returning user!
    SerialUSB.println();
    SerialUSB.print("Hi ");
    SerialUSB.print(owner.name);
    SerialUSB.print(" ");
    SerialUSB.print(owner.surname);
    SerialUSB.println(", nice to see you again :-)");
  }
}

void loop() {
  // Do nothing...
}

