
// This is the command sequence that initialises the HX8357D driver
//
// This setup information uses simple 8 bit SPI writecommand() and writedata() functions
//
// See ST7735_Setup.h file for an alternative format


// Configure HX8357D display

// setextc
writecommand(HX8357D_SETC);
writedata(0xFF);
writedata(0x83);
writedata(0x57);
delay(300);

// setRGB which also enables SDO
writecommand(HX8357_SETRGB);
writedata(0x80);  //enable SDO pin!
//  writedata(0x00);  //disable SDO pin!
writedata(0x0);
writedata(0x06);
writedata(0x06);

writecommand(HX8357D_SETCOM);
writedata(0x25);  // -1.52V

writecommand(HX8357_SETOSC);
writedata(0x68);  // Normal mode 70Hz, Idle mode 55 Hz

writecommand(HX8357_SETPANEL); //Set Panel
writedata(0x05);  // BGR, Gate direction swapped

writecommand(HX8357_SETPWR1);
writedata(0x00);  // Not deep standby
writedata(0x15);  //BT
writedata(0x1C);  //VSPR
writedata(0x1C);  //VSNR
writedata(0x83);  //AP
writedata(0xAA);  //FS

writecommand(HX8357D_SETSTBA);
writedata(0x50);  //OPON normal
writedata(0x50);  //OPON idle
writedata(0x01);  //STBA
writedata(0x3C);  //STBA
writedata(0x1E);  //STBA
writedata(0x08);  //GEN

writecommand(HX8357D_SETCYC);
writedata(0x02);  //NW 0x02
writedata(0x40);  //RTN
writedata(0x00);  //DIV
writedata(0x2A);  //DUM
writedata(0x2A);  //DUM
writedata(0x0D);  //GDON
writedata(0x78);  //GDOFF

writecommand(HX8357D_SETGAMMA);
writedata(0x02);
writedata(0x0A);
writedata(0x11);
writedata(0x1d);
writedata(0x23);
writedata(0x35);
writedata(0x41);
writedata(0x4b);
writedata(0x4b);
writedata(0x42);
writedata(0x3A);
writedata(0x27);
writedata(0x1B);
writedata(0x08);
writedata(0x09);
writedata(0x03);
writedata(0x02);
writedata(0x0A);
writedata(0x11);
writedata(0x1d);
writedata(0x23);
writedata(0x35);
writedata(0x41);
writedata(0x4b);
writedata(0x4b);
writedata(0x42);
writedata(0x3A);
writedata(0x27);
writedata(0x1B);
writedata(0x08);
writedata(0x09);
writedata(0x03);
writedata(0x00);
writedata(0x01);

writecommand(HX8357_COLMOD);
writedata(0x55);  // 16 bit

writecommand(HX8357_MADCTL);
writedata(0xC0);

writecommand(HX8357_TEON);  // TE off
writedata(0x00);

writecommand(HX8357_TEARLINE);  // tear line
writedata(0x00);
writedata(0x02);

writecommand(HX8357_SLPOUT);  //Exit Sleep
delay(150);

writecommand(HX8357_DISPON);  // display on
delay(50);

// End of HX8357D display configuration



