#ifndef DASHBOARD_UI_H
#define DASHBOARD_UI_H

#include <lvgl.h>
#include <Arduino.h>

/* =======================
 *  Button pin mapping
 *  KEY0 → Vehicle
 *  KEY1 → Smart Home
 *  KEY2 → Super Mario (default)
 * ======================= */
constexpr int BUTTON_KEY0 = 2; // GPIO2
constexpr int BUTTON_KEY1 = 3; // GPIO3
constexpr int BUTTON_KEY2 = 5; // GPIO5

/* =======================
 *  Common color constants
 * ======================= */
#define EPAPER_BLACK 0x000000
#define EPAPER_WHITE 0xFFFFFF
#define EPAPER_RED 0xFF0000
#define EPAPER_GREEN 0x00FF00
#define EPAPER_BLUE 0x0000FF
#define EPAPER_YELLOW 0xFFFF00

/* =======================
 *  Layout parameters
 * ======================= */
#define PANEL_PADDING 10
#define BORDER_WIDTH 2
#define CORNER_RADIUS 8

/* Optional screen parameters (for reference) */
#define LV_HOR_RES_MAX 800
#define LV_VER_RES_MAX 480

/* Gauge sizes for Vehicle dashboard */
#define GAUGE_SIZE 160
#define SMALL_GAUGE_SIZE 80
#define GAUGE_CENTER_X_LEFT 200
#define GAUGE_CENTER_X_RIGHT 600
#define GAUGE_CENTER_Y 180
#define LARGE_GAUGE_SIZE 200

/* =======================
 *  UI types
 * ======================= */
typedef enum
{
    UI_SUPER_MARIO = 0,
    UI_SMART_HOME,
    UI_VEHICLE_DASHBOARD
} UIType;

/* =======================
 *  Super Mario
 * ======================= */
void create_supermario_ui();

/* =======================
 *  Smart Home
 * ======================= */
void create_smarthome_ui();
void update_temperature(float temp);
void update_humidity(int humidity);
void update_battery_voltage(float voltage);
void update_battery_capacity(int percentage);
void update_wifi_signal(int signal); // 0-4
void update_weather_status(const char *status);
void update_location(const char *location);
void add_todo_item(const char *item);
void remove_todo_item(int index);

/* =======================
 *  Vehicle Dashboard
 * ======================= */
void create_vehicle_dashboard_ui();
void update_speed_gauge(int speed);
void update_rpm_gauge(int rpm);
void update_fuel_level(int percentage);
void update_engine_temp(int temperature);
void update_gear_position(char gear);
void update_odometer(long distance);
void set_warning_indicator(uint8_t indicator_id, bool state);

#endif // DASHBOARD_UI_H
