#ifndef EEZ_LVGL_UI_SCREENS_H
#define EEZ_LVGL_UI_SCREENS_H

#include <lvgl.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _objects_t {
    lv_obj_t *smart;
    lv_obj_t *industry;
    lv_obj_t *game;
    lv_obj_t *heng;
    lv_obj_t *shu;
    lv_obj_t *clean;
    lv_obj_t *water;
    lv_obj_t *play;
    lv_obj_t *date;
    lv_obj_t *locate;
    lv_obj_t *zovey_1;
    lv_obj_t *zovey;
    lv_obj_t *debin;
    lv_obj_t *heng_1;
    lv_obj_t *gear;
    lv_obj_t *vegetable;
    lv_obj_t *heng_3;
    lv_obj_t *sx;
    lv_obj_t *llx;
    lv_obj_t *co2;
    lv_obj_t *lx;
    lv_obj_t *c;
    lv_obj_t *heng_2;
} objects_t;

extern objects_t objects;

enum ScreensEnum {
    SCREEN_ID_SMART = 1,
    SCREEN_ID_INDUSTRY = 2,
    SCREEN_ID_GAME = 3,
};

void create_screen_smart();
void tick_screen_smart();

void create_screen_industry();
void tick_screen_industry();

void create_screen_game();
void tick_screen_game();

void tick_screen_by_id(enum ScreensEnum screenId);
void tick_screen(int screen_index);

void create_screens();


#ifdef __cplusplus
}
#endif

#endif /*EEZ_LVGL_UI_SCREENS_H*/