@echo off
setlocal enabledelayedexpansion

rem Auto flash latest .bin (or .hex) in current directory using xiao_samd11_openocd_flash.py
rem Usage:
rem   flash.bat                -> auto-pick newest .bin (fallback newest .hex)
rem   flash.bat myimage.bin    -> use specified file
rem Env overrides:
rem   set FLASH_PY=python3     -> choose python interpreter
rem   set FLASH_SPEED=1000     -> adapter speed kHz
rem   set FLASH_BASE=0x00000000 -> base address for .bin (if different)

set "PY=%FLASH_PY%"
if "%PY%"=="" set "PY=python"
set "SCRIPT=xiao_samd11_openocd_flash.py"

if not exist "%SCRIPT%" (
	echo [ERROR] Script %SCRIPT% not found in %cd%.
	exit /b 1
)

set "IMAGE=%~1"
if not "%IMAGE%"=="" goto :flash

rem Pick newest .bin
for /f %%F in ('dir /b /a:-d /o:-d *.bin 2^>nul') do (
	set "IMAGE=%%F"
	goto :flash
)
rem Fallback to newest .hex
for /f %%F in ('dir /b /a:-d *.hex 2^>nul') do (
	set "IMAGE=%%F"
	goto :flash
)

echo [ERROR] No .bin or .hex file found in %cd%.
exit /b 2

:flash
echo [INFO] Using image: %IMAGE%

set "BASE=%FLASH_BASE%"
if "%BASE%"=="" set "BASE=0x00000000"
set "SPEED=%FLASH_SPEED%"
if "%SPEED%"=="" set "SPEED=1000"

rem Determine if chosen file is .bin to include base address flag only when needed
set "EXT=%IMAGE:~-4%"
set "BASE_ARG="
if /i "%EXT%"==".bin" set "BASE_ARG=--base-addr %BASE%"

echo [INFO] Adapter speed: %SPEED% kHz
echo [INFO] Invoking: %PY% %SCRIPT% --file "%IMAGE%" --openocd-speed %SPEED% --reset-after --auto-install-openocd %BASE_ARG%

%PY% "%SCRIPT%" --file "%IMAGE%" --openocd-speed %SPEED% --reset-after --auto-install-openocd %BASE_ARG%
if errorlevel 1 (
	echo [ERROR] Flash operation failed. (exit code %errorlevel%)
	exit /b %errorlevel%
)

echo [OK] Flash operation completed successfully.
exit /b 0