from serial.tools import list_ports
from time import sleep
import serial

class serialPortTool(object):
    
    def __init__(self,pid_vid_info,baudrate,debugPrint):
        self.serial = None
        self.serial_port = ""
        self.pid_vid_if = pid_vid_info
        self.baudrate = baudrate
        self.debugprint = debugPrint
    
    def find_SerialPort(self):
        timeout = 10
        while timeout > 0:
            for p in list_ports.comports():
                if self.debugprint == 1:
                    print(p[2])
                if p[2].upper().startswith(self.pid_vid_if):
                    self.serial_port = p[0]
                    if self.debugprint == 1:
                        print('INFO: Find ' +  self.pid_vid_if + ' on: ' + self.serial_port)
                    return self.serial_port
        
            sleep(0.01)
            timeout -= 1
        print("Error: No serial port found..")

    def SerialPortopen(self):
        self.serial = serial.Serial(port=self.serial_port,baudrate=self.baudrate,bytesize=8,stopbits=1,timeout=1)
#        return self.serial

    def SerialPortWrite(self,message):
        try:
            if self.debugprint == 1 :
                print("write " + message)
            self.serial.write(message + '\r\n')
        except IOError as e:
            print(e)
            self.serial.close()        

    def SerialPortReadLine(self):
        return self.serial.readline().strip()
            
    def SerialPortRead(self,nTime):
        rcv_message = ""
        n = 0
        while(n<nTime):
            line = self.serial.readline().strip()
            if self.debugprint == 1:
                print(line)
            if line:
                rcv_message = rcv_message + str(line)
            sleep(0.01)
            n = n+1
        return rcv_message
        
    def SerialPortClose(self):
        self.serial.close()
#----------------------------------------------------------------------#
class FixSerialPortTool(object):
    
    def __init__(self,port,debugPrint):
        self.serial = None
        self.serial_port = port
        self.debugprint = debugPrint
    

    def SerialPortopen(self):
        self.serial = serial.Serial(port=self.serial_port,baudrate=115200,bytesize=8,stopbits=1,timeout=1)
#        return self.serial

    def SerialPortWrite(self,message):
        try:
            if self.debugprint == 1 :
                print("write " + message)
            self.serial.write(message + '\r\n')
        except IOError as e:
            print(e)
            self.serial.close()
            
    def SerialPortReadLine(self):
        return self.serial.readline().strip()
            
    def SerialPortRead(self,nTime):
        rcv_message = ""
        n = 0
        while(n<nTime):
            line = self.serial.readline().strip()
            if self.debugprint == 1:
                print(line)
            if line:
                rcv_message = rcv_message + line
            sleep(0.01)
            n = n+1
        return rcv_message
        
    def SerialPortClose(self):
        self.serial.close()        
        
        