from SerialDeviceControl import serialPortTool
import subprocess
import argparse

exe_path = "flasher.exe"
arguments1 = ["", "", "--sn"]
arguments2 = ["", "", "--offset", "0x400000"]
arguments3 = ["", ""]

EnablePrintDebugInfo = 1
keeptesting = True
Port = ""


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='参数检测')
    parser.add_argument('param', type=int, choices=[1, 2, 3], help='参数值为1或2或3')
    parser.add_argument('address', type=str, help='地址参数')
    args = parser.parse_args()
    print("烧录文件:", args.address)

    VersionAI = serialPortTool('USB VID:PID=1A86:55D3',921600,EnablePrintDebugInfo)
    try: 
        Port = VersionAI.find_SerialPort()
    except Exception as e:
        print("VersionAI Device Serial Port Error")

    if Port is not None:
        print("Serial port found: " + Port)
    else:
        keeptesting = False
        print("Error: No serial port found.")

    if keeptesting == True:
        if args.param == 1:
            arguments1 [1] = Port
            arguments1 [0] = args.address
            print("串口号为：{}".format(arguments1 [1]))
            print("===== 出厂固件烧录=====")
            subprocess.run([exe_path] + arguments1)
        elif args.param == 2:
            arguments2 [1] = Port
            arguments2 [0] = args.address
            print("串口号为：{}".format(arguments2 [1]))
            print("===== 出厂模型烧录=====")
            subprocess.run([exe_path] + arguments2)
        elif args.param == 3:
            arguments3 [1] = Port
            arguments3 [0] = args.address
            print("串口号为：{}".format(arguments3 [1]))
            print("===== 测试固件烧录=====")
            subprocess.run([exe_path] + arguments3)
        else:
            print("参数错误")