#pragma once

#include <Arduino.h>

struct HourItem
{
    uint32_t ts = 0;
    float temp = NAN;
    int weatherId = 0;
    String main;
    String desc;
    String icon;
    float windSpeed = 0;
    float windGust = 0;
};

struct DayItem
{
    uint32_t ts = 0;
    float day = NAN;
    float min = NAN;
    float max = NAN;
    int weatherId = 0;
    String main;
    String desc;
    String icon;
};

struct AlertItem
{
    String event;
    String sender;
    String description;
    uint32_t start = 0;
    uint32_t end = 0;
    String severity;
};

struct WeatherData
{
    String cityName;
    int timezoneOffset = 0;
    uint32_t dt = 0;
    float temp = NAN;
    float feelsLike = NAN;
    int humidity = 0;
    float windSpeed = 0;
    float windGust = 0;
    int windDeg = 0;
    int weatherId = 0;
    String main;
    String desc;
    String icon;
    HourItem hourly[4];
    DayItem daily[3];
    bool hasAlert = false;
    AlertItem alert;
    int aqi = 0;
    String aqiLabel = "Unknown";
    float indoorTemp = NAN;
    int indoorHumidity = -1;
};

struct WeatherRequest
{
    String apiKey;
    String units = "metric";
    String lang = "en";
    bool useCity = true;
    String city = "";
    String lat = "";
    String lon = "";
};

// Fetch weather, forecast and AQI data. Returns true on success.
bool fetchWeather(const WeatherRequest &request, WeatherData &out);
