#include "BTHome.h"
#include "Wire.h"
#include "DHT.h"

#define DHTTYPE DHT20   // DHT 20
#define DEVICE_NAME "DIY-sensor"  // 
// #define ENABLE_ENCRYPT // 

DHT dht(DHTTYPE);         //   DHT10 DHT20 don't need to define Pin
String BIND_KEY = "231d39c1d7cc1ab1aee224cd096db932"; // Change this key with a string containing 32 of: a-f and 0-9 characters (hex) this will be asked in HA
BTHome bthome;

void setup() {
  Serial.begin(115200);
#ifdef ENABLE_ENCRYPT
  bthome.begin(DEVICE_NAME, true, BIND_KEY, false);
#else
  bthome.begin(DEVICE_NAME, false, "", false);
#endif
  Wire.begin();
  dht.begin();
}

void loop() {
  float temp_hum_val[2] = {0};
  if (!dht.readTempAndHumidity(temp_hum_val)) 
  {
    Serial.print("Humidity: ");
    Serial.print(temp_hum_val[0]);
    Serial.print(" %\t");
    Serial.print("Temperature: ");
    Serial.print(temp_hum_val[1]);
    Serial.println(" *C");
  } 
  else 
  {
    Serial.println("Failed to get temprature and humidity value.");
  }
  //MEASUREMENT_MAX_LEN = 23, ENABLE_ENCRYPT will use extra 8 bytes, so each Measurement should smaller than 15

  // 1st method: just addMeasurement as much as you can, the code will split and send the adv packet automatically
  // each adv packet sending lasts for 1500ms
  bthome.resetMeasurement();// 重置测量数据缓冲区，准备添加新数据
  // bthome.addMeasurement(sensorid, value) you can use the sensorids from the BTHome.h file
  // the Object ids of addMeasurement have to be applied in numerical order (from low to high) in your advertisement
  bthome.addMeasurement(ID_TEMPERATURE_PRECISE, temp_hum_val[1]);//3
  bthome.addMeasurement(ID_HUMIDITY_PRECISE, temp_hum_val[0]);//3
  bthome.addMeasurement(ID_PRESSURE, 1023.86f);//4
  bthome.addMeasurement(ID_ILLUMINANCE, 50.81f);//4 bytes
  bthome.addMeasurement_state(STATE_POWER_ON, STATE_ON);//2
  bthome.addMeasurement(ID_CO2, (uint64_t)1208);//3
  bthome.addMeasurement(ID_TVOC, (uint64_t)350);//3
  bthome.addMeasurement_state(EVENT_BUTTON, EVENT_BUTTON_PRESS);//2 button press
  bthome.addMeasurement_state(EVENT_DIMMER, EVENT_DIMMER_RIGHT, 6); //3, rotate right 6 steps

  // Timestamp data, represented as UTC epoch
  bthome.addMeasurement(ID_TIMESTAMP, (uint64_t)1738797643);

  bthome.sendPacket();
  bthome.stop();
  delay(1500);
}